# -*- coding: utf-8 -*-


def build_logging(log_path):
    return {
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'default': {
                'format': '%(process)d %(asctime)s %(name)-15s %(levelname)-10s %(message)s',
            },
            'event': {
                'format': '%(message)s',
            }
        },
        'root': {
            'handlers': [
                'logbroker_client.debug',
                'logbroker_client.info',
                'logbroker_client.warning',
                'exception',
            ],
            'level': 'DEBUG',
        },
        'handlers': {
            'console': {
                'class': 'logging.StreamHandler',
                'level': 'DEBUG',
                'formatter': 'default',
            },
            'exception': {
                'class': 'logging.FileHandler',
                'filename': log_path + 'exception.log',
                'level': 'ERROR',
                'formatter': 'default',
            },
            'logbroker_client.debug': {
                'class': 'logging.FileHandler',
                'filename': log_path + 'debug.log',
                'level': 'DEBUG',
                'formatter': 'default',
            },
            'logbroker_client.info': {
                'class': 'logging.FileHandler',
                'filename': log_path + 'info.log',
                'level': 'INFO',
                'formatter': 'default',
            },
            'logbroker_client.warning': {
                'class': 'logging.FileHandler',
                'filename': log_path + 'warning.log',
                'level': 'WARNING',
                'formatter': 'default',
            },
        },
        'loggers': {}
    }
