# -*- coding: utf-8 -*-

from setuptools import setup, find_packages


def version(package):
    import os
    import subprocess
    import re

    # Fetch version from git tags, and write to __version__.py.
    # Also, when git is not available (PyPi package), use stored __version__.py.
    version_py = os.path.join(os.path.dirname(__file__), package, '__version__.py')

    try:
        __version__ = re.sub('^v', '', subprocess.check_output(["git", "describe", "--tags"]).rstrip().decode("utf-8"))
    except:
        import importlib
        __version__ = importlib.import_module('{package}.__version__'.format(package=package)).__version__

    with open(version_py, 'w') as version_file:
        version_file.write('''# Do not edit this file, autogenerated from git tags
__version__ = '%s'
''' % __version__)

    return __version__


setup(
    name='yandex-community-logbroker-client-py',
    version=version('logbroker_client'),
    author='rubtsovdmv,tmalikova,arhibot',
    author_email='passport-dev@yandex-team.ru',
    scripts=[
        'bin/logbroker-client.py',
        'bin/logbroker-client-status',
    ],
    packages=find_packages(exclude=('tests', 'tests.*')),
    url='https://github.yandex-team.ru/logbroker-community/logbroker-client-py',
    install_requires=[line.strip()
                      for line in open('./requirements/requirements.txt').read().splitlines()
                      if not line.startswith('-') and line.strip()],
)
