package config

import (
	"os"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	zp "go.uber.org/zap"
)

type Config struct {
	Logger   zp.Config
	TvmToken string
	TvmURL   string
	DB       *db
	LB       *lb
}

type db struct {
	Host string
	Port int
	User string
	Pass string
	Name string
}

type lb struct {
	Token       string
	Endpoint    string
	Topic       string
	Consumer    string
	Database    string
	UseTLS      bool
	MaxMessages int
}

const (
	CfgEnvProduction  = "production"
	CfgEnvDevelopment = "development"
	dbHost            = "c-mdb0r5flaekksgta4v3j.rw.db.yandex.net"
	dbPort            = 6432
)

func NewConfig(endpoint, topic, consumer, database string, useTLS bool, maxMessages int) *Config {
	lb := &lb{
		Endpoint:    endpoint,
		Topic:       topic,
		Consumer:    consumer,
		Database:    database,
		UseTLS:      useTLS,
		MaxMessages: maxMessages,
	}

	db := &db{
		Host: dbHost,
		Port: dbPort,
		User: os.Getenv("DB_USER"),
		Pass: os.Getenv("DB_PASS"),
		Name: "act_db",
	}

	if os.Getenv("ENV") == CfgEnvProduction {
		return &Config{
			Logger:   zap.NewProductionDeployConfig(),
			TvmToken: os.Getenv("TVMTOOL_LOCAL_AUTHTOKEN"),
			TvmURL:   os.Getenv("DEPLOY_TVM_TOOL_URL"),
			LB:       lb,
			DB:       db,
		}
	}

	lb.Token = os.Getenv("LOGBROKER_TOKEN")

	return &Config{
		Logger: zap.TSKVConfig(log.InfoLevel),
		LB:     lb,
		DB:     db,
	}
}
