#!/bin/bash

function http_call() {
    curl --silent --retry 2 --retry-delay 5 --fail --show-error "$@"
}

function update_panel() {
    panel_path=$1
    panel_name=$(echo $panel_path | sed 's|/|_|' )
    echo "update panel $1"
    data=$(http_call --data-binary @$panel_path.j2 "https://yasm.yandex-team.ru/srvambry/tmpl/panels/update/content?key=$panel_name")
    if [[ $? != 0 ]]; then
        echo "update failed, server response: $data"
        SUCCESSFULL="false"
        if has_fail_fast_flag; then exit -1; fi
    fi
}

panels=$(ls *.j2)
if [[ $? == 0 ]]; then
    for panel in ${panels[@]}; do
        update_panel ${panel%.*}
    done
fi
