#pragma once

#include <logdog/logger.h>
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wold-style-cast"
#include <spdlog/spdlog.h>
#pragma GCC diagnostic pop

#define LOGDOG_TO_SPDLOG_MAP_LEVEL(From, To)\
    namespace boost { namespace hana {\
    template<>\
    struct to_impl<::spdlog::level::level_enum, std::decay_t<decltype(logdog::From)>> {\
        constexpr static auto apply(const std::decay_t<decltype(logdog::From)>& ) {return ::spdlog::level::To;}\
    };\
    }}

LOGDOG_TO_SPDLOG_MAP_LEVEL(error, critical)
LOGDOG_TO_SPDLOG_MAP_LEVEL(warning, warn)
LOGDOG_TO_SPDLOG_MAP_LEVEL(notice, info)
LOGDOG_TO_SPDLOG_MAP_LEVEL(debug, debug)
#undef LOGDOG_TO_SPDLOG_MAP_LEVEL

namespace logdog {

template <>
struct applicable_impl<::spdlog::async_logger> {
    template <typename T>
    static decltype(auto) call(::spdlog::async_logger& logger, const level_type<T>& l) {
        return logger.should_log(hana::to<::spdlog::level::level_enum>(l));
    }
};

template <>
struct write_data_impl<::spdlog::async_logger> {
    template <typename T>
    static decltype(auto) call(::spdlog::async_logger& logger, const level_type<T>& l,
            const std::string& what) {
        return logger.force_log(hana::to<::spdlog::level::level_enum>(l), "{}", what);
    }
};

} //namespace logdog
