#pragma once

#include <logdog/logger.h>

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wsign-conversion"
#endif

#include <yplatform/log.h>

#ifdef __clang__
#pragma clang diagnostic pop
#endif

#define LOGDOG_TO_YLOG_MAP_LEVEL(From, To)\
    namespace boost::hana {\
    template<>\
    struct to_impl<::yplatform::log::severity_level, std::decay_t<decltype(logdog::From)>> {\
        constexpr static auto apply(const std::decay_t<decltype(logdog::From)>& ) {\
            return ::yplatform::log::severity_level::To;\
        }\
    };\
    }

LOGDOG_TO_YLOG_MAP_LEVEL(error, error)
LOGDOG_TO_YLOG_MAP_LEVEL(warning, warning)
LOGDOG_TO_YLOG_MAP_LEVEL(notice, info)
LOGDOG_TO_YLOG_MAP_LEVEL(debug, debug)
#undef LOGDOG_TO_YLOG_MAP_LEVEL

namespace logdog {

template <>
struct applicable_impl<::yplatform::log::source> {
    template <typename T>
    static decltype(auto) call(const ::yplatform::log::source& logger, const level_type<T>& l) {
        return logger.should_log(hana::to<::yplatform::log::severity_level>(l));
    }
};

template <>
struct write_data_impl<::yplatform::log::source> {
    template <typename T>
    static decltype(auto) call(const ::yplatform::log::source& logger, const level_type<T>& l,
            const std::string& what) {
        for (auto stream = logger.write(hana::to<::yplatform::log::severity_level>(l));
             stream; stream.close()) {
            stream << what;
        }
    }
};

} //namespace logdog
