#pragma once

#include <logdog/logger.h>
#include <gmock/gmock.h>

namespace logdog::testing {

using namespace ::testing;

struct logger_mock {
    template <typename Level>
    constexpr bool applicable(Level) const { return true; }

    MOCK_METHOD(void, warning, (const std::string&), (const));
    MOCK_METHOD(void, error, (const std::string&), (const));
    MOCK_METHOD(void, notice, (const std::string&), (const));
    MOCK_METHOD(void, debug, (const std::string&), (const));
};

using logger_nice_mock = NiceMock<logger_mock>;
using logger_strict_mock = StrictMock<logger_mock>;

} // namespace logdog::testing

namespace logdog {
template <>
struct write_data_impl<testing::logger_mock> {

    template <typename Data, typename Level>
    static decltype(auto) call(const testing::logger_mock& l, Level level, const Data& d) {
        if constexpr (decltype(level==error)::value) {
            return l.error(message(d));
        } else if constexpr (decltype(level==notice)::value) {
            return l.notice(message(d));
        } else if constexpr (decltype(level==debug)::value) {
            return l.debug(message(d));
        } else if constexpr (decltype(level==warning)::value) {
            return l.warning(message(d));
        } else {
            static_assert(std::is_void_v<Level>, "level is not supported by this mock");
        }
    }
};

template <>
struct write_data_impl<testing::logger_nice_mock> :
    write_data_impl<testing::logger_mock>{};

template <>
struct write_data_impl<testing::logger_strict_mock> :
    write_data_impl<testing::logger_mock>{};

} // namespace logdog
