#pragma once

#include <boost/variant.hpp>

namespace logdog {

using boost::variant;

template <typename Visitor, typename Variant>
inline decltype(auto) visit(Visitor&& v, Variant&& in) {
    return boost::apply_visitor(v, in);
}

} // namespace logdog

namespace logdog {

template <typename ...Ts>
using make_attr_variant = variant<Ts..., std::reference_wrapper<std::add_const_t<Ts>>...>;

template <typename T>
struct is_variant : std::false_type {};

template <typename ...Ts>
struct is_variant<variant<Ts...>> : std::true_type {};

}
