#pragma once

#include <macs/types.h>
#include <optional>
#include <cstdint>
#include <string>
#include <ctime>

#include <yamail/data/reflection.h>


namespace macs {

enum class ArchiveState {
    archivation_in_progress,
    archivation_complete,
    archivation_error,
    restoration_in_progress,
    restoration_complete,
    restoration_error,
    restoration_requested,
    cleaning_requested,
    cleaning_in_progress
};

using TaskId = std::int64_t;

struct Archive {
    int32_t version;
    ArchiveState state;

    int32_t message_count;
    int32_t restored_message_count;

    std::time_t updated;
    std::optional<std::string> notice;

    std::optional<TaskId> task_id;
};

enum class ExchangeArchiveStateStatus {
    user_not_here = ENUM_ERROR_STARTING_VALUE,
    user_wrong_state,
    archive_not_found
};

}

YREFLECTION_ADAPT_ENUM(macs::ArchiveState,
    archivation_in_progress,
    archivation_complete,
    archivation_error,
    restoration_in_progress,
    restoration_complete,
    restoration_error,
    restoration_requested,
    cleaning_requested,
    cleaning_in_progress
)

YREFLECTION_ADAPT_ENUM(macs::ExchangeArchiveStateStatus,
    user_not_here,
    user_wrong_state,
    archive_not_found
)
