#pragma once

#include <macs/archive.h>

namespace macs {

struct ExchangeArchiveStateCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "exchange_archive_state";
    }

    std::string message(int v) const override;
};
const ExchangeArchiveStateCategory& getExchangeArchiveStateCategory();
mail_errors::error_code::base_type make_error_code(ExchangeArchiveStateStatus e);
mail_errors::error_code make_error(ExchangeArchiveStateStatus e);

}

namespace boost::system {
template <>
struct is_error_code_enum<macs::ExchangeArchiveStateStatus> : std::true_type {};
}
