#pragma once

#include <macs/backup.h>

namespace macs {

struct CreateBackupCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "create_backup";
    }

    std::string message(int v) const override;
};
const CreateBackupCategory& getCreateBackupCategory();
mail_errors::error_code::base_type make_error_code(CreateBackupStatus e);
mail_errors::error_code make_error(CreateBackupStatus e);


struct RestoreBackupCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "restore_backup";
    }

    std::string message(int v) const override;
};
const RestoreBackupCategory& getRestoreBackupCategory();
mail_errors::error_code::base_type make_error_code(RestoreBackupStatus e);
mail_errors::error_code make_error(RestoreBackupStatus e);


struct FillBackupCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "fill_backup";
    }

    std::string message(int v) const override;
};
const FillBackupCategory& getFillBackupCategory();
mail_errors::error_code::base_type make_error_code(FillBackupStatus e);
mail_errors::error_code make_error(FillBackupStatus e);

struct DeactivateBackupCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "deactivate_backup";
    }

    std::string message(int v) const override;
};
const DeactivateBackupCategory& getDeactivateBackupCategory();
mail_errors::error_code::base_type make_error_code(DeactivateBackupStatus e);
mail_errors::error_code make_error(DeactivateBackupStatus e);

}

namespace boost::system {
template <>
struct is_error_code_enum<macs::CreateBackupStatus> : std::true_type {};
template <>
struct is_error_code_enum<macs::RestoreBackupStatus> : std::true_type {};
template <>
struct is_error_code_enum<macs::FillBackupStatus> : std::true_type {};
template <>
struct is_error_code_enum<macs::DeactivateBackupStatus> : std::true_type {};
}
