#pragma once

#include <macs/backup.h>
#include <yamail/data/reflection.h>


YREFLECTION_ADAPT_ENUM(macs::BackupState,
    in_progress,
    complete,
    inactive,
    error
)

YREFLECTION_ADAPT_ENUM(macs::RestoreState,
    in_progress,
    complete,
    error
)

YREFLECTION_ADAPT_ENUM(macs::RestoreMethod,
    full_hierarchy,
    restored_folder
)


YREFLECTION_ADAPT_ENUM(macs::CreateBackupStatus,
    empty_folder_list,
    too_many_messages,
    unique_violation,
    running_restore,
    nothing_to_backup,
    backup_id_not_reserved
)

YREFLECTION_ADAPT_ENUM(macs::FillBackupStatus,
    wrong_state,
    nothing_to_backup,
    backup_is_missing
)

YREFLECTION_ADAPT_ENUM(macs::RestoreBackupStatus,
    unique_violation,
    backup_is_missing,
    another_backup_is_running,
    wrong_state
)

YREFLECTION_ADAPT_ENUM(macs::DeactivateBackupStatus,
    restore_in_progress,
    missing_complete_backup
)
