/**
 * @file:  connection_info.h
 * © 2011 Yandex LLC.
 *
 */
#ifndef MACS_CONNECTION_INFO_H
#define MACS_CONNECTION_INFO_H

#include <memory>
#include <macs/data_source_service.h>
#include <macs/labels_repository.h>
#include <macs/folders_repository.h>
#include <macs/envelopes_repository.h>
#include <macs/threads_repository.h>
#include <macs/labels_repository_imap.h>
#include <macs/imap_repository.h>
#include <macs/database_info.h>

namespace macs {

class LabelsRepository;
class EnvelopesRepository;

struct RepositoriesHolder
{
    std::unique_ptr< LabelsRepository > labels;
    std::unique_ptr< FoldersRepository > folders;
    std::unique_ptr< EnvelopesRepository > envelopes;
    std::unique_ptr< ThreadsRepository > threads;
    std::unique_ptr< DataSourceService > service;
    std::unique_ptr< ImapLabelsRepository > imapLabels;
    std::unique_ptr< ImapRepository > imapRepo;
    std::unique_ptr< DatabaseInfo > databaseInfo;
};
typedef std::unique_ptr<RepositoriesHolder> RepositoriesHolderPtr;

class storage;
struct ConnectionInfo;
typedef std::unique_ptr<ConnectionInfo> ConnectionInfoPtr;

/// connection_info for storage class
/// no pure virtual methods because of not-deep copy is using
/// in storage class
struct ConnectionInfo {
public:
    ConnectionInfo() : autocreate(false) { }

    ConnectionInfo(const string & suid_,
                   const string & country_,
                   bool autocreate_,
                   const string & db_info_ = "",
                   const string & connection_id_ = "",
                   const string & db_source_name_ = "",
                   const string & ip_ = "")
    : suid(suid_),
    country(country_),
    autocreate(autocreate_),
    db_info(db_info_),
    id(connection_id_),
    db_source_name(db_source_name_),
    ip(ip_) { }

    virtual ~ConnectionInfo() { }

    ConnectionInfo & operator=(const ConnectionInfo & orig) = delete;

    virtual ConnectionInfoPtr clone() const {
        throw std::runtime_error("cant clone abstract connection info");
    }

    virtual RepositoriesHolderPtr createRepositories() const {
        throw std::runtime_error("cant create repos using abstract connection info");
    }

    // common
    string suid; ///!< suid
    string country; ///!< country
    bool autocreate; ///!< account autocreate
    string db_info; ///!< user db information
    string id; ///!< connection id
    string db_source_name; ///!< db-source name
    string ip; ///!< ip
};

} //macs

#endif  /* CONNECTION_INFO_H */
