/**
 * @file   data_sources.h
 * @author Sergey Nikishin
 * © 2011 Yandex LLC.
 */

#ifndef MACS_DATA_SOURCES_H
#define	MACS_DATA_SOURCES_H

#include <list>
#include <stdarg.h>

#include <boost/shared_ptr.hpp>
#include <boost/variant.hpp>
#include <boost/unordered_map.hpp>

#include <macs/data/stats.h>


namespace macs
{

class DataSourceService : public std::enable_shared_from_this<DataSourceService> {
public:
    virtual ~DataSourceService() {}

    virtual void get_stats ( data::stats::storage_info & stats ) = 0;

    /// init mailbox
    virtual void init_mailbox ( const std::string & suid, const std::string & country ) = 0;
};

typedef std::shared_ptr<DataSourceService> DataSourceServicePtr;

}


#endif	/* DATA_SOURCES_H */

