#pragma once

#include <string>
#include <boost/optional.hpp>
#include <macs/hooks.h>
#include <macs/database_info_types.h>

namespace macs {

    struct DatabaseInfo : public std::enable_shared_from_this<DatabaseInfo> {
        virtual ~DatabaseInfo () {};

        template <typename Handler = io::sync_context>
        auto getState(Handler handler = io::use_sync) const {
            io::detail::init_async_result<Handler, OnDatabaseState> init(handler);
            syncDatabaseInfo(init.handler);
            return init.result.get();
        }

        protected:
            virtual void syncDatabaseInfo(OnDatabaseState) const  = 0;

    };

    typedef std::shared_ptr<DatabaseInfo> DatabaseInfoPtr;
}
