#pragma once

#include <string>

namespace macs {

struct DatabaseState {
    enum class State {
        readWrite,              // master and both replicas are alive
        readOnly,               // master is dead and both replicas are alive
        singleReplica,          // master and only one replica are alive
        singleReplicaOnly,      // master is dead and only one replica is alive
        masterOnly,             // master is alive and both replicas are dead
        dbDead                  // master and both replicas are dead
    };

    std::string name;
    State state = State::readWrite;
};

}
