#ifndef MACS_DETAIL_BITMASK_H_
#define MACS_DETAIL_BITMASK_H_

#define MACS_BIT2(n) (1 << n)

// #include <macs/macs.h>
#include <boost/integer.hpp>

namespace macs
{
namespace detail
{

template < typename T, size_t SZ = T::_LAST > class bitmask;

template <typename T, size_t SZ>
bitmask<T, SZ> operator| ( bitmask<T, SZ> const & c1, bitmask<T, SZ> const & c2 );

template <typename T, size_t SZ>
bitmask<T, SZ> operator& ( bitmask<T, SZ> const & c1, bitmask<T, SZ> const & c2 );

template <typename T, size_t SZ>
bitmask<T, SZ> operator- ( bitmask<T, SZ> const & c1, bitmask<T, SZ> const & c2 );

template <typename T, size_t SZ>
bool operator== ( bitmask<T, SZ> const & c1, bitmask<T, SZ> const & c2 );


template <typename T, size_t SZ>
class bitmask
{
    typedef typename boost::uint_value_t < SZ - 1 >::fast type;

public:
    inline bitmask ( T const & t ) : t_ ( static_cast<type> ( t ) ) {}

protected:
    friend bitmask operator| <> ( bitmask const &, bitmask const & );
    friend bitmask operator& <> ( bitmask const &, bitmask const & );
    friend bitmask operator- <> ( bitmask const &, bitmask const & );

    friend bool operator== <> ( bitmask const &, bitmask const & );

    inline bitmask ( type const & t ) : t_ ( t ) {}
    inline type const & raw () const {
        return t_;
    }

private:
    type t_;
};

template <typename T, size_t SZ>
inline bitmask<T, SZ>
operator| ( bitmask<T, SZ> const & c1, bitmask<T, SZ> const & c2 )
{
    return bitmask<T, SZ> ( c1.raw () | c2.raw () );
}

template <typename T, size_t SZ>
inline bitmask<T, SZ>
operator& ( bitmask<T, SZ> const & c1, bitmask<T, SZ> const & c2 )
{
    return bitmask<T, SZ> ( c1.raw () & c2.raw () );
}

template <typename T, size_t SZ>
inline bitmask<T, SZ>
operator- ( bitmask<T, SZ> const & c1, bitmask<T, SZ> const & c2 )
{
    return bitmask<T, SZ> ( c1.raw () & ( ~c2.raw () ) );
}

template <typename T, size_t SZ>
inline bool
operator== ( bitmask<T, SZ> const & c1, bitmask<T, SZ> const & c2 )
{
    return c1.raw () == c2.raw ();
}

template <typename T, size_t SZ>
inline bool
operator^ ( bitmask<T, SZ> const & c1, bitmask<T, SZ> const & c2 )
{
    return ( c1 & c2 ) == c2;
}

}
}
#endif // MACS_DETAIL_BITMASK_H_
