#ifndef MACS_DETAIL_CMAP_H_
#define MACS_DETAIL_CMAP_H_

#include <boost/unordered_map.hpp>

namespace macs
{
namespace detail
{

// unordered_map with const [] operator
// simplify use [] in const context
template < typename Key, typename Mapped,
         typename Hash = boost::hash<Key>,
         typename Pred = std::equal_to<Key>,
         typename Alloc = std::allocator<Key> >
class cmap
    : public boost::unordered_map<Key, Mapped, Hash, Pred, Alloc>
{
    typedef boost::unordered_map<Key, Mapped, Hash, Pred, Alloc> base_t;
public:
    typedef typename base_t::size_type size_type;
    typedef typename base_t::hasher hasher;
    typedef typename base_t::key_equal key_equal;
    typedef typename base_t::allocator_type allocator_type;
    typedef typename base_t::mapped_type mapped_type;
    typedef typename base_t::value_type value_type;
    typedef typename base_t::key_type key_type;
    typedef typename base_t::const_iterator const_iterator;
    typedef typename base_t::iterator iterator;

    explicit cmap ( size_type n = 1,
                    hasher const & h = hasher(),
                    key_equal const & e = key_equal(),
                    allocator_type const & a = allocator_type() )
        : base_t ( n, h, e, a )
    {}

    template<typename InputIterator>
    cmap ( InputIterator f, InputIterator l,
           size_type n = 1,
           hasher const & h = hasher(), key_equal const & e = key_equal(),
           allocator_type const & a = allocator_type() )
        : base_t ( f, l, n, h, e, a )
    {}

    cmap ( cmap const & other ) : base_t ( other ) {}
    // cmap (cmap && other) : base_t (other) {}
    explicit cmap ( Alloc const & a ) : base_t ( a ) {}
    cmap ( cmap const & other, Alloc const & a ) : base_t ( other, a ) {}

    mapped_type & operator[] ( key_type const & k ) {
        return ( * ( ( this->insert ( value_type ( k, mapped_type() ) ) ).first ) ).second;
    }

    mapped_type const & operator[] ( key_type const & k ) const {
        static mapped_type const default_value = mapped_type ();
        const_iterator i = this->find ( k );
        if ( i != this->end () ) {
            return i->second;
        } else {
            return default_value;
        }
    }
};

}
}

#endif //  MACS_DETAIL_CMAP_H_
