// Boost.rangeT library
//
//  Copyright Thorsten Ottosen 2003-2004. Use, modification and
//  distribution is subject to the Boost Software License, Version
//  1.0. (See accompanying file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt)
//
// For more information, see http://www.boost.org/libs/range/
//

#ifndef BOOST_RANGE_IS_RANGE_OF_HPP
#define BOOST_RANGE_IS_RANGE_OF_HPP

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
# pragma once
#endif

#include <boost/range/config.hpp>
#include <boost/range/value_type.hpp>
#include <boost/type_traits/is_same.hpp>
#include <boost/mpl/eval_if.hpp>

// #include <boost/range/is_range.hpp>
#include <macs/detail/is_range.h>

namespace macs
{
namespace detail
{
namespace range_detail
{
template<typename rangeT, typename elementT>
struct is_range_of_impl {
    typedef boost::is_same<elementT, typename boost::range_value<rangeT>::type> type;
};

template<typename rangeT, typename elementT>
struct is_range_convertible_impl {
    typedef boost::is_same<elementT, typename boost::range_value<rangeT>::type> type;
};
}
template<typename rangeT, typename elementT>
struct is_range_of : boost::mpl::eval_if<is_range<rangeT>, range_detail::is_range_of_impl<rangeT, elementT>, boost::mpl::false_>::type {
};
template<typename rangeT, typename elementT>
struct is_range_convertible : boost::mpl::eval_if<is_range<rangeT>, range_detail::is_range_convertible_impl<rangeT, elementT>, boost::mpl::false_>::type {
};
}
}


#endif
