#pragma once

#include <list>
#include <iostream>

namespace macs
{
namespace detail
{

//Derive from it, and you will have dictionary with your derived class's objects
template<typename T>
class ObjectsDict {
public:
    typedef std::list<const T*> Dict;

    static const Dict& getDict() noexcept {
        return dict();
    }

protected:
    static Dict& dict() noexcept {
        try {
            static Dict dict_;
            return dict_;
        } catch (...) {
            std::cerr << __PRETTY_FUNCTION__ << ": Houston we have a problem!" << std::endl;
            std::terminate();
        }
    }

    ObjectsDict() {
        insert();
    }
    ObjectsDict(ObjectsDict<T>&&) noexcept {}
    ObjectsDict(const ObjectsDict&) {}
    ObjectsDict& operator = (ObjectsDict<T>&&) noexcept { return *this;}
    ObjectsDict& operator = (const ObjectsDict&) { return *this;}

    ~ObjectsDict() noexcept {
        erase();
    }
private:
    void insert() {
        dict().push_back( static_cast<const T*>( this ) );
        this->i = --(dict().end());
    }
    void erase() noexcept {
        try {
            if( i!=dict().end() ) {
                dict().erase( i );
            }
        } catch (...) {
            std::cerr << __PRETTY_FUNCTION__ << ": Houston we have a problem!" << std::endl;
        }
    }
    typename Dict::iterator i = dict().end();
};

}
}

