#ifndef MACS_DETAIL_TIME_TRAITS_H_
#define MACS_DETAIL_TIME_TRAITS_H_
#include <macs/macs.h>

#include <boost/date_time/posix_time/posix_time_types.hpp>

namespace macs
{
namespace detail
{

typedef ::boost::posix_time::time_duration default_duration;

template <typename TimeDuration>
class time_traits
{
};

template <>
class time_traits < ::boost::posix_time::time_duration>
{
public:
    typedef ::boost::posix_time::time_duration duration_type;
    typedef ::boost::posix_time::ptime         abs_time_type;

    inline static
    abs_time_type now () {
        return ::boost::posix_time::microsec_clock::universal_time ();
    }

    inline static duration_type
    duration ( abs_time_type const & start, abs_time_type const & stop ) {
        return ( stop - start );
    }

    inline static duration_type&
    add ( duration_type & duration1, duration_type const & duration2 ) {
        duration1 += duration2;
        return duration1;
    }

};

}
}
#endif // MACS_DETAIL_TIME_TRAITS_H_
