#pragma once

#include <macs/folder.h>

#define MODIFIER(NAME,FIELD,TYPE) \
    FolderFactory & NAME (TYPE NAME) { \
            folder.FIELD = NAME; \
            return *this; \
        }

namespace macs {

class FolderFactory {
public:
    FolderFactory() : substitute_() {
        create();
    }
    FolderFactory( const Folder & substitute ) : substitute_(substitute) {
        create();
    }
    FolderFactory & create() {
        folder = substitute_;
        return *this;
    }

    FolderFactory& name(const std::string& rawName) {
        folder.name_ = detail::normalizeName(rawName);
        return *this;
    }

    MODIFIER(fid, fid_, const string &)
    MODIFIER(symbol, symbol_, const Folder::Symbol &)
    MODIFIER(type, type_, const Folder::Type &)
    MODIFIER(bytes, bytes_, const size_t)
    MODIFIER(messages, messagesCount_, const size_t)
    MODIFIER(newMessages, newMessagesCount_, const size_t)
    MODIFIER(recentMessages, recentMessagesCount_, const size_t)
    MODIFIER(unvisited, unvisited_, const bool)

    MODIFIER(parentId, parentId_, const string &)
    MODIFIER(position, position_, size_t)
    MODIFIER(creationTime, creationTime_, const string &)
    MODIFIER(subscribedForSharedFolder, subscribedForSharedFolder_, bool)

    MODIFIER(revision, revision_, const Revision)
    MODIFIER(imapUidNext, imapUidNext_, const size_t)
    MODIFIER(imapUidValidity, imapUidValidity_, const size_t)
    MODIFIER(imapFirstUnseen, imapFirstUnseen_, const size_t)
    MODIFIER(pop3On, pop3On_, const bool)
    MODIFIER(isThreadable, isThreadable_, const bool)

    const Folder & product() const {
        return folder;
    }

    operator Folder() const {
        return folder;
    }

private:
    const Folder substitute_;
    Folder folder;
};

} // namespace macs

#undef MODIFIER

