#pragma once

#include <macs/io.h>
#include <macs/revision.h>
#include <macs/types.h>
#include <macs/mime_part.h>
#include <macs/data.h>
#include <macs/label.h>
#include <macs/envelope.h>
#include <macs/thread_participants.h>
#include <macs/imap_folder.h>
#include <macs/imap_envelope.h>
#include <macs/folder.h>
#include <macs/database_info_types.h>
#include <macs/thread_mailbox_list.h>
#include <macs/thread_labels.h>
#include <macs/label_set.h>
#include <macs/folder_set.h>
#include <macs/tab_set.h>
#include <macs/settings.h>
#include <macs/settings_queries_types.h>
#include <macs/freezing_info.h>
#include <macs/backup.h>
#include <macs/archive.h>
#include <macs/sticker.h>

namespace macs {

typedef std::vector<ImapEnvelope> ImapEnvelopeChunk;
typedef std::vector<ImapUidMapRecord> ImapUidMapChunk;
typedef std::vector<ImapEnvelopeChanges> ImapEnvelopeChangesChunk;
typedef std::vector<ImapEnvelopeDetails> ImapEnvelopeDetailsChunk;
typedef std::vector<ImapUnsubscribedData> ImapUnsubscribedDataChunk;
typedef std::vector<Pop3Message> Pop3MessageChunk;
typedef std::vector<Pop3PartialMessage> Pop3PartialMessageChunk;

namespace hooks {
namespace export_ {

using io_result::Sequence;
using io_result::Optional;
using namespace io_result::hooks::export_;

typedef std::vector<Envelope> EnvelopeChunk;
typedef Hook<EnvelopeChunk> OnEnvelopeChunkReceive;
typedef Hook<Sequence<Envelope>> OnEnvelopeReceive;

typedef Hook<Attachments> OnAttachmentsReceive;

typedef Hook<RfcMessageId> OnRfcMessageId;

typedef Hook<std::time_t> OnUnixTime;
typedef Hook<Optional<std::time_t>> OnUnixTimeOptional;

typedef Hook<Revision>  OnRevisionReceive;

typedef Hook<ThreadMailboxItems> OnThreadMailboxItemsReceive;
typedef Hook<ThreadLabelsList> OnThreadLabelsReceive;
typedef Hook<ThreadParticipantsList> OnParticipantsReceive;

typedef Hook<ImapUnsubscribedDataChunk> OnImapUnsubscribed;

typedef Hook<ImapUidMapChunk> imap_uid_map_entry;

typedef Hook<ImapEnvelopeChunk> imap_envelope_entry;

typedef Hook<ImapEnvelopeChangesChunk> imap_envelope_changes_entry;

typedef Hook<ImapEnvelopeDetailsChunk> imap_envelope_details_entry;

typedef Hook<uint32_t> imap_envelope_oper;

typedef Hook<Pop3Folder> pop3_folder_entry;

typedef Hook<Pop3MessageChunk> pop3_full_message_entry;

typedef Hook<Pop3PartialMessageChunk> pop3_partial_message_entry;

typedef Hook<> OnExecute;

typedef Hook<Revision> OnUpdate;

struct UpdateMessagesResult {
    Revision rev;
    std::size_t affected;
};

typedef Hook<UpdateMessagesResult> OnUpdateMessages;

struct CopyResult {
    Revision rev;
    std::vector<Mid> mids;
};

typedef Hook<CopyResult> OnCopy;

typedef Hook<MidList> OnMidsReceive;

typedef Hook<Folder> OnUpdateFolder;

typedef Hook<Label> OnUpdateLabel;

typedef Hook<size_t> OnCountReceive;

enum class EnvelopeKind { original, duplicate };
typedef std::tuple<Envelope, EnvelopeKind> UpdateEnvelopeResult;
typedef Hook<UpdateEnvelopeResult> OnUpdateEnvelope;

typedef Hook<DatabaseState> OnDatabaseState;

typedef Hook<MidsWithStids> OnMidsWithStidsReceive;

typedef Hook<Optional<Stid>> OnStIdReceive;

typedef Hook<MimeParts> OnMimePartsReceive;

typedef Hook<MidsWithMimes> OnMidsWithMimes;

using MidsWithMimesAndAttaches = std::vector<std::tuple<Mid, Stid, MimeParts, Attachments>>;
using OnMidsWithMimesAndAttaches = Hook<MidsWithMimesAndAttaches>;

typedef Hook<MidAndImapIdVec> OnMidsAndImapIds;

typedef Hook<Mid> CheckDuplicates;

typedef Hook<TidVector> OnThreadIdsReceive;
typedef Hook<ThreadId> OnThreadIdReceive;

typedef Hook<LabelSet> OnLabels;
typedef Hook<FolderSet> OnFolders;
typedef Hook<FoldersMap> OnFoldersMap;
typedef Hook<Pop3Folders> OnPop3Folders;

typedef Hook<Sequence<std::tuple<Envelope, MimeParts>>> OnEnvelopeWithMimeReceive;

typedef std::vector<std::tuple<Envelope, MimeParts>> EnvelopeWithMimeChunk;
typedef Hook<EnvelopeWithMimeChunk> OnEnvelopeWithMimeChunkReceive;

struct ImapIdResult {
    Revision rev;
    uint64_t imapId;
};

typedef Hook<ImapIdResult> OnImapId;

typedef Hook<Tab> OnUpdateTab;
typedef Hook<TabSet> OnTabs;

typedef Hook<settings::SettingsRawPtr> OnQuerySettings;
typedef Hook<settings::ProfilePtr> OnProfile;
typedef Hook<settings::ParametersPtr> OnParameters;
typedef Hook<settings::SettingsPtr> OnSettings;

struct AttachesCounters {
    uint64_t count;
    uint64_t seen;
};

typedef Hook<AttachesCounters> OnAttachesCounters;

typedef Hook<FreezingInfo> OnFreezingInfo;

typedef Hook<macs::BackupId> OnBackupId;
typedef Hook<BackupFolders> OnBackupFolders;
typedef Hook<BackupBox> OnBackupBox;
typedef Hook<BackupStatus> OnBackupStatus;
typedef Hook<BackupSettings> OnBackupSettings;

typedef Hook<std::optional<Archive>> onArchive;

typedef Hook<ReplyLaterSticker> OnReplyLaterSticker;
typedef Hook<ReplyLaterStickers> OnReplyLaterStickers;

typedef Hook<MidVec> OnIncorrectStickersMids;

}// namespace export_

using namespace export_;

using io_result::hooks::Strategy;

}

using namespace hooks::export_;
using hooks::Optional;
using hooks::Sequence;

}
