/**
 * @file   imap_envelope.h
 * @brief  ImapEnvalope - imap message representation
 * @author Anton Barabanov
 * © Yandex LLC.
 */
#ifndef _MACS_IMAP_ENVELOPE_H_
#define _MACS_IMAP_ENVELOPE_H_

#include <ctime>
#include <string>
#include <vector>
#include <stdint.h>

namespace macs {

struct ImapUidMapRecord {
    uint32_t uid = 0;
    uint32_t chain = 0;
};

struct ImapEnvelope {
    uint32_t uid = 0;
    uint32_t num = 0;
    uint64_t mid = 0;
    uint64_t modseq = 0;
    uint64_t flagBits = 0;
    std::time_t receivedDate = 0;
    std::vector< std::string > labels;
};

struct ImapEnvelopeChanges {
    ImapEnvelope envelope;
    uint32_t baseId = 0;
    uint32_t offset = 0;
    bool deleted = false;
};

struct ImapEnvelopeDetails {
    std::string stid;
    std::string mid;
    uint64_t size = 0;
    ImapEnvelope envelope;
};

struct Pop3PartialMessage {
    std::string uidl;
    std::size_t size = 0;
    std::string fid;

    bool isSpam = false;
    bool isNew = false;
};

struct Pop3Message {
    Pop3PartialMessage base;

    std::string mid;
    std::string stid;
};

}

#endif // _MACS_IMAP_ENVELOPE_H_
