/**
 * @file   imap_folder.h
 * @brief  ImapFolder - imap folder representation
 * @author Anton Barabanov
 * © Yandex LLC.
 */
#ifndef _MACS_IMAP_FOLDER_H_
#define _MACS_IMAP_FOLDER_H_

#include <macs/revision.h>
#include <vector>
#include <string>
#include <stdint.h>

namespace macs {

struct ImapFolder
{
    ImapFolder()
        : revision(0)
        , messageCount(0)
        , recentCount(0)
        , unseenCount(0)
        , uidNext(0)
        , uidValidity(0)
        , firstUnseen(0)
        , sysdate(0)
        , changed(0)
        , mapChanged(0)
    {}

    uint64_t revision;
    uint64_t messageCount;
    uint64_t recentCount;
    uint64_t unseenCount;
    uint64_t uidNext;
    uint64_t uidValidity;
    uint64_t firstUnseen;
    uint64_t sysdate;
    uint64_t changed;
    uint64_t mapChanged;
    std::string name;
    std::string fid;
};

struct ImapUnsubscribedData {
    std::vector<std::string> fullName;
    Revision revision = NULL_REVISION;
};

struct Pop3Folder {
    std::size_t messages = 0;
    std::string folderId;
};

}

#endif // _MACS_IMAP_FOLDER_H_
