#pragma once

#include <macs/label.h>

#define MODIFIER(NAME,FIELD,TYPE) \
    LabelFactory & NAME (TYPE NAME) { \
            label.FIELD = NAME; \
            return *this; \
        }

namespace macs {

/**
 * @class LabelFactory
 * @brief creates full Label object
 */
class LabelFactory {
public:
    LabelFactory & create(Label l = Label()) {
        label = std::move(l);
        return *this;
    }

    MODIFIER(lid, lid_, const string &)
    MODIFIER(symbol, symbol_, const Label::Symbol &)
    MODIFIER(type, type_, const Label::Type &)
    MODIFIER(newMessages, newMessagesCount_, const size_t)
    MODIFIER(imapIndex, imapIndex_, const size_t)

    MODIFIER(color, color_, const string &)
    MODIFIER(creationTime, creationTime_, const string &)
    MODIFIER(revision, revision_, const Revision)

    LabelFactory& name(const std::string & rawName) {
        label.name_ = detail::normalizeName( rawName );
        return *this;
    }

    LabelFactory& messages(const std::size_t messagesCount) {
        label.messagesCount_ = std::make_optional(messagesCount);
        return *this;
    }

    LabelFactory& unreadMessagesCount(const std::size_t unreadMessages) {
        label.unreadMessagesCount_ = unreadMessages;
        return *this;
    }

    const Label & product() const {
        return label;
    }

    operator Label() const {
        return label;
    }
    LabelFactory() = default;
    LabelFactory(Label l) : label(std::move(l)) {}

private:
    Label label;
};

} // namespace macs

#undef MODIFIER

