/**
 * @file   mailbox_space_info.h
 * @author Alexey Kremenkov
 * © Yandex LLC.
 */

#ifndef MACS_MAILBOX_SPACE_INFO_H
#define MACS_MAILBOX_SPACE_INFO_H

namespace macs {

struct MailboxSpaceInfo {
    typedef int64_t SpaceSize;

    MailboxSpaceInfo() : limit_(0), used_(0) {}

    SpaceSize limit() const {
        return limit_;
    }

    SpaceSize used() const {
        return used_;
    }

    SpaceSize free() const {
        return limit_ - used_;
    }

    void limit(SpaceSize limit) {
        limit_ = limit;
    }

    void used(SpaceSize used) {
        used_ = used;
    }

private:
    SpaceSize limit_;
    SpaceSize used_;
};

}

#endif  /* __MACS_MAILBOX_SPACE_INFO_H */
