#pragma once

#include <macs/types.h>

namespace macs {

class MimePart {
public:
#define GETTER(NAME) auto& NAME () const { return data().NAME; }
    GETTER(hid)
    GETTER(contentType)
    GETTER(contentSubtype)
    GETTER(boundary)
    GETTER(name)
    GETTER(charset)
    GETTER(encoding)
    GETTER(contentDisposition)
    GETTER(fileName)
    GETTER(cid)
    GETTER(offsetBegin)
    GETTER(offsetEnd)
#undef GETTER

    std::size_t length() const { return offsetEnd() - offsetBegin(); }

    MimePart() = default;
    MimePart(const MimePart&) = default;
    MimePart(MimePart&&) = default;
    MimePart& operator=(const MimePart&) = default;
    MimePart& operator=(MimePart&&) = default;

private:
    friend class MimePartFactory;
    struct Data {
        Hid hid;
        std::string contentType;
        std::string contentSubtype;
        std::string boundary;
        std::string name;
        std::string charset;
        std::string encoding;
        std::string contentDisposition;
        std::string fileName;
        std::string cid;

        std::size_t offsetBegin = 0;
        std::size_t offsetEnd = 0;

        static const Data default_;
    };

    std::shared_ptr<const Data> data_;

    MimePart(std::shared_ptr<const Data> data) : data_(std::move(data)) {}

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }
};

using MimeParts = std::vector<MimePart>;
using MidsWithMimes = std::vector<std::tuple<Mid, Stid, MimeParts>>;

}
