/**
 * @file   envelopes_query.h
 * @brief  Envelopes query from source repository
 * @author Sergey Nikishin
 * © Yandex LLC.
 */
#ifndef MACS_ENVELOPES_QUERY_H
#define MACS_ENVELOPES_QUERY_H

#include <string>
#include <future>

#include <macs/types.h>
#include <macs/label.h>
#include <macs/hooks.h>
#include <macs/envelope.h>
#include <macs/queries/envelopes_sorting.h>
#include <macs/io.h>

namespace macs {

/** @interface IEnvelopesQuery
 *  @brief envelopes query interface
 *
 * All queries have to provide execute() method
 * to an envelope list. Envelope list call this
 * method directly with its storage and items set as arguments.
 */
class EnvelopesQuery
{
    virtual void byEntry (OnEnvelopeReceive handler) const = 0;
public:
    template <typename Handler>
    auto get(Handler handler) const {
        io::detail::init_async_result<Handler, OnEnvelopeReceive> init(handler);
        byEntry(init.handler);
        return init.result.get();
    }
    virtual ~EnvelopesQuery() = default;
};

typedef std::shared_ptr<EnvelopesQuery> EnvelopesQueryPtr;

}

#endif  /* ENVELOPES_QUERY_H */

