#pragma once

/**
 * @file   envelopes_query_builder.h
 * @author Sergey Nikishin
 * © 2011 Yandex LLC.
 */

#include <macs/label.h>
#include <macs/folder.h>
#include <macs/queries/envelopes_query_threads.h>
#include <macs/queries/envelopes_query_in_folder.h>
#include <macs/queries/envelopes_query_in_thread.h>
#include <macs/queries/envelopes_query_in_mailbox.h>
#include <macs/queries/envelopes_query_filter_search.h>
#include <macs/queries/envelopes_query_with_no_answer.h>
#include <macs/queries/envelopes_query_in_reply_to.h>
#include <macs/queries/envelopes_query_mids_by_conditions.h>
#include <macs/queries/envelopes_query_mids_by_tid_and_with_same_headers.h>
#include <macs/queries/envelopes_query_mids_by_hdr_pairs.h>
#include <macs/queries/envelopes_query_mids_by_tids_and_lids.h>
#include <macs/queries/envelopes_query_mids_without_status.h>
#include <macs/queries/envelopes_query_with_mimes.h>
#include <macs/queries/envelopes_query_deleted.h>
#include <macs/queries/envelopes_query_in_tab.h>
#include <macs/queries/envelopes_query_mids_by_tab.h>
#include <macs/queries/envelopes_query_mids_by_label.h>

namespace macs {

class EnvelopesRepository;

class EnvelopesQueryBuilder
{
public:
    EnvelopesQueryBuilder( EnvelopesRepository & repo ): repo_(repo) {}

    EnvelopesQueryThreads threads(TidVector tids) {
        return EnvelopesQueryThreads(repo_, std::move( tids ) );
    }

    EnvelopesQueryInFolder inFolder(const Folder & folder) {
        return EnvelopesQueryInFolder(repo_, folder);
    }

    EnvelopesQueryInFolder inFolders(FidList folders) {
        return EnvelopesQueryInFolder(repo_, std::move( folders ) );
    }

    EnvelopesQueryInThread inThread(const Tid& tid) {
        return EnvelopesQueryInThread(repo_, tid);
    }

    EnvelopesQueryInMailbox inMailbox() {
        return EnvelopesQueryInMailbox(repo_);
    }

    EnvelopesQueryFilterSearch filterSearch() {
        return EnvelopesQueryFilterSearch(repo_);
    }

    EnvelopesQueryFilterSearchHistory filterSearchHistory() {
        return EnvelopesQueryFilterSearchHistory(repo_);
    }

    EnvelopesQueryWithNoAnswer withNoAnswer() {
        return EnvelopesQueryWithNoAnswer(repo_);
    }

    EnvelopesQueryInReplyTo inReplyTo() {
        return EnvelopesQueryInReplyTo(repo_);
    }

    EnvelopesQueryMidsByConditions mids(Fid fid) {
        return EnvelopesQueryMidsByConditions(repo_, fid);
    }

    EnvelopesQueryMidsByTab mids(Tab::Type tab) {
        return EnvelopesQueryMidsByTab(repo_, std::move(tab));
    }

    EnvelopesQueryMidsByLabel mids(const Label& label) {
        return EnvelopesQueryMidsByLabel(repo_, label);
    }

    EnvelopesQueryMidsByTidsAndLids midsByTidsAndLids() const {
        return EnvelopesQueryMidsByTidsAndLids(repo_);
    }

    EnvelopesQueryWithMimes withMimes() {
        return EnvelopesQueryWithMimes(repo_);
    }

    EnvelopesQueryMidsByTidAndWithSameHeaders midsByTidAndWithSameHeaders(Tid tid) {
        return EnvelopesQueryMidsByTidAndWithSameHeaders(repo_, std::move(tid));
    }

    EnvelopesQueryMidsByHdrPairs mids(HdrDateAndMessageIdVec hdrPairs) {
        return EnvelopesQueryMidsByHdrPairs(repo_, std::move(hdrPairs));
    }

    EnvelopesQueryMidsWithoutStatus withoutStatus(const MidList& mids) {
        return EnvelopesQueryMidsWithoutStatus(repo_, mids);
    }

    EnvelopesQueryDeleted deleted() {
        return EnvelopesQueryDeleted(repo_);
    }

    EnvelopesQueryInTab inTab(Tab::Type tabType) {
        return EnvelopesQueryInTab(repo_, std::move(tabType));
    }

private:
    EnvelopesRepository & repo_;
};

}
