#pragma once

#include <macs/io.h>
#include <macs/types.h>
#include <macs/hooks.h>

namespace macs
{

class EnvelopesRepository;

class EnvelopesQueryDeleted
{
public:
    EnvelopesQueryDeleted(const EnvelopesRepository& repo);

    EnvelopesQueryDeleted& from(const size_t row);
    EnvelopesQueryDeleted& count(const size_t count);
    EnvelopesQueryDeleted& withinInterval(const std::pair<std::time_t, std::time_t>& interval);

    template <typename Handler = io::sync_context>
    auto get(Handler handler = io::use_sync) const {
        io::detail::init_async_result<Handler, OnEnvelopeReceive> init{handler};
        getInternal(init.handler);
        return init.result.get();
    }

private:
    void getInternal (OnEnvelopeReceive hook) const;

    const EnvelopesRepository& repo_;
    size_t from_;
    size_t count_;
    std::optional<std::pair<std::time_t, std::time_t>> timeInterval_;
};

} // macs

