#ifndef MACS_ENVELOPES_QUERY_FILTER_SEARCH_H
#define MACS_ENVELOPES_QUERY_FILTER_SEARCH_H

#include <string>
#include <list>
#include <macs/queries/envelopes_query.h>

namespace macs {

class EnvelopesRepository;

class EnvelopesQueryFilterSearch: public EnvelopesQuery {
public:
    EnvelopesQueryFilterSearch(EnvelopesRepository & repo);

    EnvelopesQueryFilterSearch& onlyUnread(bool unread);
    EnvelopesQueryFilterSearch& onlyAtta(bool atta);
    EnvelopesQueryFilterSearch& fids(const std::list<std::string>& fids);
    EnvelopesQueryFilterSearch& lids(const std::list<std::string>& lids);
    EnvelopesQueryFilterSearch& mids(const std::list<std::string>& mids);
    EnvelopesQueryFilterSearch& folderSet(const std::string& folderSet);
    EnvelopesQueryFilterSearch& sortBy(const EnvelopesSorting & order);

    void byEntry (OnEnvelopeReceive) const override;

private:
    bool unread_;
    bool atta_;
    std::list<std::string> fids_;
    std::list<std::string> lids_;
    std::list<std::string> mids_;
    std::string folderSet_;
    EnvelopesSorting order_;
    EnvelopesRepository & repository_;

};

class EnvelopesQueryFilterSearchHistory: public EnvelopesQuery {
public:
    EnvelopesQueryFilterSearchHistory(EnvelopesRepository & repo);

    EnvelopesQueryFilterSearchHistory& mids(const std::list<std::string>& mids);

    void byEntry (OnEnvelopeReceive) const override;

private:
    std::list<std::string> mids_;
    EnvelopesRepository & repository_;

};

}

#endif //MACS_ENVELOPES_QUERY_FILTER_SEARCH_H
