#pragma once

#include <list>
#include <string>

#include <macs/label.h>
#include <macs/folder.h>
#include <macs/queries/envelopes_query.h>

namespace macs
{

class EnvelopesRepository;

class EnvelopesQueryInFolder: public EnvelopesQuery
{
public:
    EnvelopesQueryInFolder(EnvelopesRepository & repo, const Folder & folder);
    EnvelopesQueryInFolder(EnvelopesRepository & repo, FidList fids);

    EnvelopesQueryInFolder& from(const size_t row);
    EnvelopesQueryInFolder& from(const string & mid);
    EnvelopesQueryInFolder& count(const size_t count);
    EnvelopesQueryInFolder& sortBy(const EnvelopesSorting & order);
    EnvelopesQueryInFolder& groupByThreads();
    EnvelopesQueryInFolder& withLabel(const Label & label);
    EnvelopesQueryInFolder& withLabels(const std::vector<Label>& labelsVec);
    EnvelopesQueryInFolder& withoutLabel(const Label & label);
    EnvelopesQueryInFolder& withoutLabels(const std::vector<Label>& labelsVec);
    EnvelopesQueryInFolder& withinInterval(const std::pair<std::time_t, std::time_t>& interval);

    void byEntry (OnEnvelopeReceive) const override;

    struct Params {
        explicit Params(FidList fids);

        string fromMid;
        size_t from;
        size_t count;
        bool groups;
        EnvelopesSorting order;
        FidList folders;
        std::list< string > labels;
        std::list< string > excludeLabels;
        std::pair<std::time_t, std::time_t> timeInterval;
    };

private:
    EnvelopesRepository & repository_;
    Params params_;

};

} // macs

