/**
 * @file   envelopes_query_in_mailbox.h
 * @brief
 * @author Sergey Nikishin
 * © Yandex LLC.
 */
#ifndef MACS_ENVELOPES_QUERY_IN_MAILBOX_H
#define MACS_ENVELOPES_QUERY_IN_MAILBOX_H

#include <string>
#include <list>
#include <macs/queries/envelopes_query.h>

namespace macs
{

/** @class EnvelopesQueryInMailbox
 *  @brief query for envelopes in whole mailbox
 *
 * Resulting envelopes list can be threaded or not.
 */

class EnvelopesRepository;

class EnvelopesQueryInMailbox: public EnvelopesQuery
{
public:
    EnvelopesQueryInMailbox(EnvelopesRepository & repo);

    EnvelopesQueryInMailbox& from(const size_t row);
    EnvelopesQueryInMailbox& fromMid(const std::string & mid );
    EnvelopesQueryInMailbox& count(const size_t count);
    EnvelopesQueryInMailbox& sortBy(const EnvelopesSorting & order);
    EnvelopesQueryInMailbox& groupByThreads();
    EnvelopesQueryInMailbox& withLabel(const Label & label);
    EnvelopesQueryInMailbox& withoutLabel(const Label & label);

    void byEntry (OnEnvelopeReceive) const override;

private:
    size_t from_;
    std::string fromMid_;
    size_t count_;
    bool groups_;
    EnvelopesSorting order_;
    std::list< string > labels;
    std::list< string > excludeLabels;
    EnvelopesRepository & repository_;

};

}


#endif  /* ENVELOPES_QUERY_IN_MAILBOX_H */

