#pragma once

#include <list>
#include <string>

#include <macs/label.h>
#include <macs/tab.h>
#include <macs/queries/envelopes_query.h>

namespace macs
{

class EnvelopesRepository;

class EnvelopesQueryInTab: public EnvelopesQuery
{
public:
    EnvelopesQueryInTab(EnvelopesRepository& repo, Tab::Type tabType);

    EnvelopesQueryInTab& from(const size_t row);
    EnvelopesQueryInTab& count(const size_t count);
    EnvelopesQueryInTab& groupByThreads();
    EnvelopesQueryInTab& withLabel(const Label& label);
    EnvelopesQueryInTab& withLabels(const std::vector<Label>& labelsVec);
    EnvelopesQueryInTab& withoutLabel(const Label& label);
    EnvelopesQueryInTab& withoutLabels(const std::vector<Label>& labelsVec);
    EnvelopesQueryInTab& withinInterval(const std::pair<std::time_t, std::time_t>& interval);

    void byEntry (OnEnvelopeReceive) const override;

    struct Params {
        explicit Params(Tab::Type tabType);

        Tab::Type tabType;
        size_t from;
        size_t count;
        bool groupByThreads;
        std::vector< string > labels;
        std::vector< string > excludeLabels;
        std::pair<std::time_t, std::time_t> timeInterval;
    };

private:
    EnvelopesRepository& repository_;
    Params params_;

};

} // macs

