/**
 * @file   envelopes_query_in_thread.h
 * @brief
 * @author Sergey Nikishin
 * © Yandex LLC.
 */
#ifndef MACS_ENVELOPES_QUERY_IN_THREAD_H
#define MACS_ENVELOPES_QUERY_IN_THREAD_H

#include <list>
#include <string>

#include <macs/label.h>
#include <macs/queries/envelopes_query.h>

namespace macs
{

class EnvelopesRepository;

class EnvelopesQueryInThread: public EnvelopesQuery
{
public:
    EnvelopesQueryInThread(EnvelopesRepository & repo, const string & threadID);

    EnvelopesQueryInThread& from(const size_t row);
    EnvelopesQueryInThread& from(const string & mid);
    EnvelopesQueryInThread& count(const size_t count);
    EnvelopesQueryInThread& sortBy(const EnvelopesSorting & order);
    EnvelopesQueryInThread& withLabel(const Label & label);
    EnvelopesQueryInThread& withoutLabel(const Label & label);

    void byEntry (OnEnvelopeReceive) const override;

private:
    string tid_;
    string fromMid_;
    size_t from_;
    size_t count_;
    EnvelopesSorting order_;
    macs::Label label_;
    macs::Label excludeLabel_;
    EnvelopesRepository & repository_;
};

}

#endif  /* ENVELOPES_QUERY_IN_THREAD_H */

