#pragma once

#include <macs/queries/envelopes_query.h>
#include <macs/method_caller.h>
#include <macs/types.h>
#include <macs/io.h>
#include <chrono>
#include <boost/optional.hpp>

namespace macs {

class EnvelopesRepository;

class EnvelopesQueryMidsByConditions {
public:
    EnvelopesQueryMidsByConditions(const EnvelopesRepository & repo, Fid fid)
        : repo_(repo), fid_(std::move(fid)) {}

    const auto& fid() const { return fid_; }
    const auto& subject() const { return subject_;}
    const auto& from() const { return from_;}
    const auto& age() const { return age_;}

    auto& subject(std::string v) { subject_ = std::move(v); return *this; }
    auto& from(std::string v) { from_ = std::move(v); return *this; }
    auto& age(Days v) { age_ = std::move(v); return *this; }
    auto& excludeStatus(Envelope::Status v) {excludeStatus_ = v; return *this; }
    auto& fromMid(Mid v) { fromMid_ = std::move(v); return *this; }
    auto& limit(std::size_t v) { limit_ = std::move(v); return *this; }
    template <typename Handler = io::sync_context>
    auto get(Handler handler = io::use_sync) const {
        io::detail::init_async_result<Handler, OnMidsReceive> init(handler);
        getInternal(init.handler);
        return init.result.get();
    }
private:
    void getInternal(OnMidsReceive hook) const;
    const EnvelopesRepository& repo_;
    Fid fid_;
    boost::optional<std::string> subject_;
    boost::optional<std::string> from_;
    boost::optional<Days> age_;
    boost::optional<Envelope::Status> excludeStatus_;
    std::optional<Mid> fromMid_;
    std::optional<std::size_t> limit_;
};

} // namespace
