#pragma once

#include <macs/types.h>
#include <macs/io.h>
#include <macs/hooks.h>

namespace macs {

class EnvelopesRepository;

class EnvelopesQueryMidsByHdrPairs {
public:
    EnvelopesQueryMidsByHdrPairs(const EnvelopesRepository& repo, HdrDateAndMessageIdVec hdrPairs)
        : repo(repo),
          hdrPairs(std::move(hdrPairs))
    {}

    template <typename Handler = io::sync_context>
    auto get(Handler handler = io::use_sync) const {
        io::detail::init_async_result<Handler, OnMidsReceive> init(handler);
        getInternal(init.handler);
        return init.result.get();
    }

    const HdrDateAndMessageIdVec& pairs() const noexcept {
        return hdrPairs;
    }

private:
    void getInternal(OnMidsReceive hook) const;

    const EnvelopesRepository& repo;
    HdrDateAndMessageIdVec hdrPairs;
};

} // namespace macs
