#pragma once

#include <macs/queries/envelopes_query.h>
#include <macs/types.h>
#include <macs/io.h>
#include <chrono>

namespace macs {

class EnvelopesRepository;

class EnvelopesQueryMidsByLabel {
public:
    EnvelopesQueryMidsByLabel(const EnvelopesRepository & repo, Label label)
        : repo_(repo), label_(std::move(label)) {}

    template <typename Handler = io::sync_context>
    auto get(Handler handler = io::use_sync) const {
        io::detail::init_async_result<Handler, OnMidsReceive> init(handler);
        getInternal(init.handler);
        return init.result.get();
    }

private:
    void getInternal(OnMidsReceive hook) const;
    const EnvelopesRepository& repo_;
    Label label_;
};

} // namespace macs
