#pragma once

#include <macs/queries/envelopes_query.h>
#include <macs/method_caller.h>
#include <macs/types.h>
#include <macs/io.h>
#include <chrono>
#include <boost/optional.hpp>

namespace macs {

class EnvelopesRepository;

class EnvelopesQueryMidsByTab {
public:
    EnvelopesQueryMidsByTab(const EnvelopesRepository & repo, Tab::Type tab)
        : repo_(repo), tab_(std::move(tab)) {}

    auto& excludeStatus(Envelope::Status v) {
        excludeStatus_ = v;
        return *this;
    }

    template <typename Handler = io::sync_context>
    auto get(Handler handler = io::use_sync) const {
        io::detail::init_async_result<Handler, OnMidsReceive> init(handler);
        getInternal(init.handler);
        return init.result.get();
    }

private:
    void getInternal(OnMidsReceive hook) const;
    const EnvelopesRepository& repo_;
    Tab::Type tab_;
    std::optional<Envelope::Status> excludeStatus_;
};

} // namespace macs
