#pragma once

#include <macs/types.h>
#include <macs/io.h>
#include <macs/hooks.h>

namespace macs {

class EnvelopesRepository;

class EnvelopesQueryMidsByTidAndWithSameHeaders {
public:
    EnvelopesQueryMidsByTidAndWithSameHeaders(const EnvelopesRepository& repo, Tid tid)
        : repo(repo),
          tid(std::move(tid))
    {}

    template <typename Handler = io::sync_context>
    auto get(Handler handler = io::use_sync) const {
        io::detail::init_async_result<Handler, OnMidsReceive> init(handler);
        getInternal(init.handler);
        return init.result.get();
    }

private:
    void getInternal(OnMidsReceive hook) const;

    const EnvelopesRepository& repo;
    Tid tid;
};

} // namespace macs
