#pragma once

#include <macs/hooks.h>

namespace macs {

class EnvelopesRepository;

class EnvelopesQueryMidsByTidsAndLids {
public:
    explicit EnvelopesQueryMidsByTidsAndLids(const EnvelopesRepository& repositoryToSet);

    EnvelopesQueryMidsByTidsAndLids& withLids(Lids lidsToSet);
    EnvelopesQueryMidsByTidsAndLids& withTids(Tids tidsToSet);

    template <typename Handler = io::sync_context> auto get(Handler handler = io::use_sync) const {
        io::detail::init_async_result<Handler, OnMidsReceive> init{handler};
        getInternal(init.handler);
        return init.result.get();
    }

private:
    void getInternal(OnMidsReceive handler) const;

    const EnvelopesRepository& repository;
    Tids tids;
    Lids lids;
};

}
