#pragma once

#include <macs/types.h>
#include <macs/envelope.h>
#include <macs/hooks.h>
#include <io_result/use_sync.h>

namespace macs {

class EnvelopesRepository;

class EnvelopesQueryMidsWithoutStatus {
public:
    EnvelopesQueryMidsWithoutStatus(EnvelopesRepository& repo, const MidList& mids) :
        repository_(repo), mids_(mids), status_() {
    }

    auto& status(Envelope::Status status) {
        status_ = std::move(status);
        return *this;
    }

    template <typename Handler = io::sync_context>
    auto get(Handler handler = io::use_sync) const {
        io::detail::init_async_result<Handler, OnMidsReceive> init{handler};
        getInternal(init.handler);
        return init.result.get();
    }

private:
    void getInternal(OnMidsReceive hook) const;

    EnvelopesRepository& repository_;
    const MidList& mids_;
    boost::optional<Envelope::Status> status_;
};

} // namespace macs
