#pragma once

namespace macs
{
/** @enum SortingType
 *  @brief sort direction
 */
enum SortingType {
    SortingType_ascending = 0,
    SortingType_descending,
    SortingType_none
};

/** @class EnvelopeSorting
 *  @brief describes messages sorting
 */
class EnvelopesSorting
{
public:
    EnvelopesSorting() = default;
    /// create
    EnvelopesSorting(SortingType type)
    : type_(type) {}

    /// get sort type
    SortingType type() const { return type_; }
private:
    SortingType type_ = SortingType_none;   ///< sorting type (asc/desc)
};

inline bool operator==(const EnvelopesSorting& lhs, const EnvelopesSorting& rhs) {
    return lhs.type() == rhs.type();
}

} // ns macs
