#ifndef MACS_REVISION_H
#define MACS_REVISION_H

namespace macs {

class Revision {
public:
    using Value = unsigned long;
    Revision(Value v) : v(v) {}
    Revision() = default;
    constexpr Value value() const { return v; }
    constexpr operator Value () const { return value(); }
    static constexpr Revision null() { return Revision(); }
private:
    Value v = 0;
};

const Revision NULL_REVISION;

} // namespace macs

#endif // MACS_REVISION_H
