#pragma once

#include <macs/settings_description.h>

namespace macs::settings {

const Description::SettingsRestrictions Description::production = {
    .profile = {
        {"abook_page_size", {"50", {}, Limits {1, 5000}, Updatability::updated, Type::no_type}},
        {"alert_on_empty_subject", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"broad_view", {"", {}, {}, Updatability::updated, Type::flag}},
        {"close_quoting", {"", {}, {}, Updatability::updated, Type::flag}},
        {"collect_addresses", {"on", {}, {}, Updatability::updated,Type::flag}},
        {"color_scheme", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"copy_smtp_messages_to_sent", {"", {}, {}, Updatability::updated, Type::flag}},
        {"daria_welcome_page", {"", {}, {}, Updatability::updated, Type::flag}},
        {"default_mailbox", {
            "yandex.ru",
            {
                "yandex.ru",
                "narod.ru",
                "ya.ru",
                "yandex.ua",
                "yandex.com",
                "yandex.by",
                "yandex.kz",
                "yandex.com.tr"
            }, {}, Updatability::updated, Type::no_type}
        },
        {"disable_social_notification", {"", {}, {}, Updatability::readonly, Type::flag}},
        {"dnd_enabled", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"dont_delete_msg_from_imap", {"", {}, {}, Updatability::updated, Type::flag}},
        {"duplicate_menu", {"", {}, {}, Updatability::updated, Type::flag}},
        {"enable_autosave", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_firstline", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_hotkeys", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_images", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_images_in_spam", {"", {}, {}, Updatability::updated, Type::flag}},
        {"enable_imap", {"", {}, {}, Updatability::updated, Type::flag}},
        {"enable_mailbox_selection", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_pop", {"", {}, {}, Updatability::updated, Type::flag}},
        {"enable_pop3_max_download", {"", {}, {}, Updatability::updated, Type::flag}},
        {"enable_quoting", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_richedit", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_social_notification", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_welcome_page", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"first_login", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"folder_thread_view", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"from_name_eng", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"have_seen_daria", {"", {}, {}, Updatability::updated, Type::flag}},
        {"have_seen_stamp", {"", {}, {}, Updatability::updated, Type::flag}},
        {"hide_daria_header", {"", {}, {}, Updatability::updated, Type::flag}},
        {"hide_tip_for_video_letter", {"", {}, {}, Updatability::updated, Type::flag}},
        {"https_enabled", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"imap_rename_enabled", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"interface_settings", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"jump_to_next_message", {"", {}, {}, Updatability::updated, Type::flag}},
        {"label_sort", {"by_count", {"by_count", "by_abc"}, {}, Updatability::updated, Type::no_type}},
        {"messages_per_page", {"30", {}, Limits {1, 200}, Updatability::updated, Type::no_type}},
        {"ml_to_inbox", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"mobile_messages_per_page", {"15", {}, Limits {1, 200}, Updatability::updated, Type::no_type}},
        {"mobile_sign", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"new_interface_by_default", {"", {}, {}, Updatability::updated, Type::flag}},
        {"no_advertisement", {"", {}, {}, Updatability::readonly, Type::flag}},
        {"no_firstline", {"", {}, {}, Updatability::readonly, Type::flag}},
        {"no_mailbox_selection", {"", {}, {}, Updatability::readonly, Type::flag}},
        {"no_news", {"", {}, {}, Updatability::readonly, Type::flag}},
        {"page_after_delete", {
            "current_list",
            {
                "current_list",
                "next_message",
                "deleted_list",
                "inbox"
            }, {}, Updatability::updated, Type::no_type}
        },
        {"page_after_move", {
            "current_list",
            {
                "current_list",
                "next_message",
                "source_folder",
                "dest_folder"
            }, {}, Updatability::updated, Type::no_type}
        },
        {"page_after_send", {"done", {"done", "current_list", "sent_list"}, {}, Updatability::updated, Type::no_type}},
        {"pop3_archivate", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"pop3_makes_read", {"", {}, {}, Updatability::updated, Type::flag}},
        {"pop3_max_download", {"50", {}, Limits {50, 100}, Updatability::updated, Type::no_type}},
        {"pop_spam_enable", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"pop_spam_subject_mark_enable", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"quotation_char", {">", {}, Limits {33, 126}, Updatability::updated, Type::chr}},
        {"save_sent", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"show_advertisement", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"show_avatars", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"show_chat", {"", {}, {}, Updatability::updated, Type::flag}},
        {"show_news", {"", {}, {}, Updatability::updated, Type::flag}},
        {"show_socnet_avatars", {"", {}, {}, Updatability::updated, Type::flag}},
        {"show_stocks", {"", {}, {}, Updatability::updated, Type::flag}},
        {"show_todo", {"", {}, {}, Updatability::updated, Type::flag}},
        {"show_unread", {"", {}, {}, Updatability::updated, Type::flag}},
        {"show_weather", {"", {}, {}, Updatability::updated, Type::flag}},
        {"signature", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"signature_eng", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"signature_top", {"", {}, {}, Updatability::updated, Type::flag}},
        {"skin_name", {"neo2", {"neo2", "neo", "classic", "modern"}, {}, Updatability::updated, Type::no_type}},
        {"subs_messages_per_page", {"20", {}, Limits {1, 100}, Updatability::updated, Type::no_type}},
        {"subs_show_informer", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"subs_show_item", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"subs_show_line", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"subs_show_unread", {"", {}, {}, Updatability::updated, Type::flag}},
        {"suggest_addr_maxnum", {"500", {}, Limits {1, 5000}, Updatability::updated, Type::no_type}},
        {"suggest_addresses", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"translate", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"use_monospace_in_text", {"", {}, {}, Updatability::updated, Type::flag}},
        {"use_small_fonts", {"", {}, {}, Updatability::updated, Type::flag}},
        {"webchat_turned_off", {"", {}, {}, Updatability::updated, Type::flag}},
        {"yandex_sign_enable", {"", {}, {}, Updatability::updated, Type::flag}},
        {"from_name", {std::nullopt, {}, {}, Updatability::updated, Type::flag}},
        {"default_email", {std::nullopt, {}, {}, Updatability::updated, Type::no_type}}
    },
    .parameters = {
        {"messages_avatars", {"on", {}, {}, Updatability::updated, Type::no_type}},
        {"search-version", {"2014.03.14", {}, {}, Updatability::updated, Type::no_type}},
        {"localize_imap", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"u2709", {"on", {}, {}, Updatability::updated, Type::no_type}},
        {"show_checkbox_inside_userpic", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"flight_notify", {"true", {}, {}, Updatability::updated, Type::no_type}},
        {"enable_imap_auth_plain", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"has_pro_interface", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"has_priority_support", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"is_ad_disabled_via_billing", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"is_user_b2b_mail", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"is_user_b2b_disk", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"priority_mail", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"mail_b2c_can_use_backup", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"mail_b2c_can_use_hidden_trash", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"mail_b2c_can_use_opt_in_subs", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"mail_b2b_admin_search_allowed", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"mail_b2b_admin_search_enabled", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"show_folders_tabs", {"on", {}, {}, Updatability::updated, Type::flag}}
    }
};

const Description::SettingsRestrictions Description::corp = {
    .profile = {
        {"abook_page_size", {"50", {}, Limits {1, 5000}, Updatability::updated, Type::no_type}},
        {"alert_on_empty_subject", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"broad_view", {"", {}, {}, Updatability::updated, Type::flag}},
        {"close_quoting", {"", {}, {}, Updatability::updated, Type::flag}},
        {"collect_addresses", {"on", {}, {}, Updatability::updated,Type::flag}},
        {"color_scheme", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"copy_smtp_messages_to_sent", {"", {}, {}, Updatability::updated, Type::flag}},
        {"daria_welcome_page", {"", {}, {}, Updatability::updated, Type::flag}},
        {"default_mailbox", {
            "yandex-team.ru",
            {
                "mail.yandex-team.com.tr",
                "mail.yandex-team.com.ua",
                "mail.yandex-team.com",
                "mail.yandex-team.ru",
                "yandex-team.com.tr",
                "yandex-team.com.ua",
                "yandex-team.com",
                "yandex-team.ru"
            }, {}, Updatability::updated, Type::no_type}
        },
        {"disable_social_notification", {"", {}, {}, Updatability::readonly, Type::flag}},
        {"dnd_enabled", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"dont_delete_msg_from_imap", {"", {}, {}, Updatability::updated, Type::flag}},
        {"duplicate_menu", {"", {}, {}, Updatability::updated, Type::flag}},
        {"enable_autosave", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_firstline", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_hotkeys", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_images", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_images_in_spam", {"", {}, {}, Updatability::updated, Type::flag}},
        {"enable_imap", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_mailbox_selection", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_pop", {"", {}, {}, Updatability::updated, Type::flag}},
        {"enable_pop3_max_download", {"", {}, {}, Updatability::updated, Type::flag}},
        {"enable_quoting", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_richedit", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_social_notification", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"enable_welcome_page", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"first_login", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"folder_thread_view", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"from_name_eng", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"have_seen_daria", {"", {}, {}, Updatability::updated, Type::flag}},
        {"have_seen_stamp", {"", {}, {}, Updatability::updated, Type::flag}},
        {"hide_daria_header", {"", {}, {}, Updatability::updated, Type::flag}},
        {"hide_tip_for_video_letter", {"", {}, {}, Updatability::updated, Type::flag}},
        {"https_enabled", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"imap_rename_enabled", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"interface_settings", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"jump_to_next_message", {"", {}, {}, Updatability::updated, Type::flag}},
        {"label_sort", {"by_count", {"by_count", "by_abc"}, {}, Updatability::updated, Type::no_type}},
        {"messages_per_page", {"30", {}, Limits {1, 200}, Updatability::updated, Type::no_type}},
        {"ml_to_inbox", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"mobile_messages_per_page", {"15", {}, Limits {1, 200}, Updatability::updated, Type::no_type}},
        {"mobile_sign", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"new_interface_by_default", {"", {}, {}, Updatability::updated, Type::flag}},
        {"no_advertisement", {"", {}, {}, Updatability::readonly, Type::flag}},
        {"no_firstline", {"", {}, {}, Updatability::readonly, Type::flag}},
        {"no_mailbox_selection", {"", {}, {}, Updatability::readonly, Type::flag}},
        {"no_news", {"", {}, {}, Updatability::readonly, Type::flag}},
        {"page_after_delete", {
            "current_list",
            {
                "current_list",
                "next_message",
                "deleted_list",
                "inbox"
            }, {}, Updatability::updated, Type::no_type}
        },
        {"page_after_move", {
            "current_list",
            {
                "current_list",
                "next_message",
                "source_folder",
                "dest_folder"
            }, {}, Updatability::updated, Type::no_type}
        },
        {"page_after_send", {"done", {"done", "current_list", "sent_list"}, {}, Updatability::updated, Type::no_type}},
        {"pop3_archivate", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"pop3_makes_read", {"", {}, {}, Updatability::updated, Type::flag}},
        {"pop3_max_download", {"50", {}, Limits {50, 100}, Updatability::updated, Type::no_type}},
        {"pop_spam_enable", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"pop_spam_subject_mark_enable", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"quotation_char", {">", {}, Limits {33, 126}, Updatability::updated, Type::chr}},
        {"save_sent", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"show_advertisement", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"show_avatars", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"show_chat", {"", {}, {}, Updatability::updated, Type::flag}},
        {"show_news", {"", {}, {}, Updatability::updated, Type::flag}},
        {"show_socnet_avatars", {"", {}, {}, Updatability::updated, Type::flag}},
        {"show_stocks", {"", {}, {}, Updatability::updated, Type::flag}},
        {"show_todo", {"", {}, {}, Updatability::updated, Type::flag}},
        {"show_unread", {"", {}, {}, Updatability::updated, Type::flag}},
        {"show_weather", {"", {}, {}, Updatability::updated, Type::flag}},
        {"signature", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"signature_eng", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"signature_top", {"", {}, {}, Updatability::updated, Type::flag}},
        {"skin_name", {"neo2", {"neo2", "neo", "classic", "modern"}, {}, Updatability::updated, Type::no_type}},
        {"subs_messages_per_page", {"20", {}, Limits {1, 100}, Updatability::updated, Type::no_type}},
        {"subs_show_informer", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"subs_show_item", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"subs_show_line", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"subs_show_unread", {"", {}, {}, Updatability::updated, Type::flag}},
        {"suggest_addr_maxnum", {"500", {}, Limits {1, 5000}, Updatability::updated, Type::no_type}},
        {"suggest_addresses", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"translate", {"on", {}, {}, Updatability::updated, Type::flag}},
        {"use_monospace_in_text", {"", {}, {}, Updatability::updated, Type::flag}},
        {"use_small_fonts", {"", {}, {}, Updatability::updated, Type::flag}},
        {"webchat_turned_off", {"", {}, {}, Updatability::updated, Type::flag}},
        {"yandex_sign_enable", {"", {}, {}, Updatability::updated, Type::flag}},
        {"from_name", {std::nullopt, {}, {}, Updatability::updated, Type::flag}},
        {"default_email", {std::nullopt, {}, {}, Updatability::updated, Type::no_type}}
    },
    .parameters = {
        {"messages_avatars", {"on", {}, {}, Updatability::updated, Type::no_type}},
        {"search-version", {"2014.03.14", {}, {}, Updatability::updated, Type::no_type}},
        {"localize_imap", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"u2709", {"on", {}, {}, Updatability::updated, Type::no_type}},
        {"show_checkbox_inside_userpic", {"", {}, {}, Updatability::updated, Type::no_type}},
        {"is_node_user", {"on", {}, {}, Updatability::updated, Type::no_type}},
        {"enable_imap_auth_plain", {"on", {}, {}, Updatability::updated, Type::no_type}},
        {"mail_b2c_can_use_backup", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"mail_b2c_can_use_hidden_trash", {"", {}, {}, Updatability::defended, Type::no_type}},
        {"show_folders_tabs", {"on", {}, {}, Updatability::updated, Type::flag}}
    }
};

}
