#pragma once

#include <macs/settings.h>

#include <optional>

namespace macs::settings {

struct SettingsRaw {
    SignaturesListOpt signs;
    std::optional<SettingsMap> single_settings;

    SettingsRaw() = default;
    SettingsRaw(const SettingsMap& single_settings_, const SignaturesListOpt& signs_ = std::nullopt)
        : signs(signs_)
        , single_settings(single_settings_) {}
};

using SettingsRawPtr = std::shared_ptr<SettingsRaw>;

}
