#pragma once

#include <macs/types.h>
#include <yamail/data/reflection/reflection.h>

namespace macs {

enum class StickerType {
    reply_later,
};

struct ReplyLaterSticker {
    macs::Mid mid;
    macs::StickerType type;
    std::time_t created;
    macs::Tid tid;
    macs::Fid fid;
    std::time_t date;
    std::optional<macs::Tab::Type> tab;
};

using ReplyLaterStickers = std::vector<ReplyLaterSticker>;

} //namespace macs

YREFLECTION_ADAPT_ENUM(macs::StickerType,
    reply_later
)
