#pragma once

#include <macs/tab.h>

namespace macs {

class TabFactory: private TabDataInterface<TabFactory> {
public:

#define MODIFIER(NAME) \
    TabFactory & NAME (const decltype(TabData::NAME) & v) { \
        data().NAME = std::move(v); \
        return *this; \
    }

    MODIFIER(type)
    MODIFIER(bytes)
    MODIFIER(messagesCount)
    MODIFIER(newMessagesCount)
    MODIFIER(freshMessagesCount)
    MODIFIER(creationTime)
    MODIFIER(revision)

#undef MODIFIER

    TabFactory() = default;
    TabFactory(const Tab& src)
    : data_(std::make_shared<TabData>(src.data())) {
    }

    const TabDataInterface<TabFactory>& product() const {
        return *this;
    }

    TabFactory& reset() {
        data_.reset();
        return *this;
    }

    Tab release() {
        auto retval = std::move(data_);
        reset();
        return Tab(std::move(retval));
    }

    TabFactory(const TabFactory& ) = delete;
    TabFactory(TabFactory&&) = default;
    TabFactory& operator=(const TabFactory&) = delete;
    TabFactory& operator=(TabFactory&&) = default;

private:
    friend class TabDataInterface<TabFactory>;

    TabData& data() {
        if(!data_) {
            data_ = std::make_shared<TabData>();
        }
        return *data_;
    }
    const TabData& data() const {
        return data_ ? *data_ : TabData::default_;
    }

    std::shared_ptr<TabData> data_;
};

} // namespace macs
