#pragma once

#include <string>
#include <unordered_map>
#include <vector>
#include <boost/range/adaptors.hpp>
#include <boost/property_tree/ptree.hpp>
#include <macs/label_set.h>

namespace macs {
namespace deprecated {

struct Tab {
    enum class Type {
        unknown,
        empty,
        withLabel,
        withoutLabels,
        whole
    };

    Type type;
    Label label;
    std::vector<Label> excludeLabels;
};

struct UnknownTabException : public std::invalid_argument {
    UnknownTabException(const std::string& msg)
        : std::invalid_argument(msg) {}
};

class TabsMap {
public:
    using Map = std::unordered_map<std::string, std::string>;

    TabsMap(Map map) : map_(std::move(map)) {}

    Tab getTab(const LabelSet&, const std::string&) const;
    std::unordered_map<std::string, Tab> getAllTabs(const LabelSet&) const;

    using LabelTypes = std::vector<std::string>;
    std::pair<LabelTypes, LabelTypes> getLabelsToChange(const std::string& tabName) const;

    const Map& getMap() const {
        return map_;
    }

    static const std::string& defaultTab();
    static bool isDefaultTab(const std::string& tabName);

private:
    static const std::vector<std::string> defaultNames_;

    Map map_;

    std::string getType(const std::string& tabName) const;
};

TabsMap initTabsMap(const boost::property_tree::ptree&, const std::string& nodeName);

} // namespace deprecated
} // namespace macs
